#!/usr/bin/python3

import sys

gold_file = open(sys.argv[1], 'rt')
test_file = open(sys.argv[2], 'rt')
wrong_samples_file = open(sys.argv[3], 'wt')

total_samples = correct_samples = 0
while True:
    gold_line = gold_file.readline()
    test_line = test_file.readline()
    if not gold_line or not test_line:
        break
    gold_lang = gold_line.split('\t', 1)[0]
    if gold_lang == 'unknown':
        continue #ignore samples unsure even after a manual check
    test_lang = test_line.split('\t', 1)[0]
    if test_lang == gold_lang:
        correct_samples += 1
    else:
        wrong_samples_file.write('%s\t%s' % (gold_lang, test_line))
    total_samples += 1

sys.stdout.write('Accuracy @ %d samples: %.3f\n' %
    (total_samples, correct_samples / total_samples))
sys.stdout.write('Wrong samples written to %s\n' % sys.argv[3])
