#!/usr/bin/python3

import sys
from src_langid.langid import langid

ACCEPTED_LANGS = {
    'cs': 'czech',
    'sk': 'slovak',
    'en': 'english',
}

for line in sys.stdin:
    line = line.strip()
    lang = None
    for lang_code, value in langid.rank(line):
        lang = ACCEPTED_LANGS.get(lang_code)
        if lang:
            break
    if not lang:
        lang = 'unknown'
    sys.stdout.write('%s\t%s\n' % (lang, line))
