#!/usr/bin/python3

import sys

result_files = [open(path, 'rt') for path in sys.argv[1:]]

end_of_file = False
while True:
    langs = set()
    for fp in result_files:
        line = fp.readline()
        if not line:
            end_of_file = True
            break
        lang, text = line.strip().split('\t', 1)
        langs.add(lang)
    if end_of_file:
        break
    if len(langs) > 1:
        result_lang = 'DISAGREEMENT'
    else:
        result_lang = lang
    sys.stdout.write('%s\t%s\n' % (result_lang, text))
